<?php

namespace Import\ApiBundle\Services\Import;


class ImportInterestRateFPAndFGSP extends ImportMainService
{
    protected $url = 'http://www.wskazniki.gofin.pl/9,117,763,1,stopy-procentowe-skladek-na-fundusz-pracy-i-na-fundusz.html';

    protected $columns = array("Okres","Value");

    protected $errors = array();

    public function import()
    {
        $this->type = 'ImportInterestRateFPAndFGSP';

        $title = 'Stopy procentowe składek na Fundusz Pracy i na Fundusz Gwarantowanych Świadczeń Pracowniczych';
        $links = $this->getLinksFromPage($this->url,$title);
        $links = array_reverse($links);

        $count = 0;
        foreach($links as $link)
        {
            $InterestRateFPAndFGSP = $this->getDoctrine()->getRepository('ImportApiBundle:InterestRateFPAndFGSP')->getInterestRateFPAndFGSPForMonthAndYear($link['month'],$link['year'],$link['monthTo'],$link['yearTo']);
            if(empty($InterestRateFPAndFGSP))
            {
                $link['value'] = $this->getInterestRateFPAndFGSPFromPage($link['href']);
                $this->save($link);
                $count++;
            }
        }
        $this->getDoctrine()->getEntityManager()->flush();
        $this->viewErrors();

        return array('count' => $count);
    }

    protected function validRow($row)
    {
        $valid = true;

        foreach($this->columns as $column)
        {
            if((!isset($column)) || ($row[$column] == ' ') || (empty($row[$column])))
            {
                $valid = false;
                $this->addError(1,$column,$this->type);
            }
        }

        return $valid;
    }

    protected function addDataToRow($row)
    {
        $data = $row[$this->columns[0]];
        $data = str_replace('od','',$data);
        $data = str_replace('r.','',$data);
        $data = str_replace('za','',$data);
        $data = str_replace('dzień','',$data);
        $data = trim($data);

        $dataArray = explode(' ',$data);

        if(count($dataArray) != 3)
        {
            return false;
        }

        $DataTime = $this->createDataFromArray($dataArray);

        if(!$DataTime)
        {
            $this->addError(2,$row[$this->columns[0]],$this->type);
            return false;
        }
        $row['DataFrom'] = $DataTime;

        $row[$this->columns[1]] = trim($row[$this->columns[1]]);
        $row[$this->columns[1]] = str_replace(',','.',$row[$this->columns[1]]);

        return $row;
    }

    protected function save($data)
    {
        $this->getDoctrine()->getRepository('ImportApiBundle:InterestRateFPAndFGSP')->add($data);

        return true;
    }
}